' *************************** LC METER MKIII ********************************************************
'
' Measure L and C from 1 pF to 1000 pF and 1 uH to 1000 uH
'
' Uses Arduino Nano ATMega328P
'



$regfile = "m328pdef.dat"                              ' Chip description
$hwstack = 50                                          ' make sure stacks big enough
$swstack = 50
$framesize = 50
$crystal = 16000000                                    ' 16 MHz crystal on NANO



Ddrb = &B00_0111                                       ' 0-3 are CAP switches
Portb = &B11_1000

Ddrc = &B0000_1000
Portc = &B0000_0000

Ddrd = &B1011_0000
Portd = &B0100_1011

$baud = 38400

Dim Zero_flag As Bit
Dim Window As Bit
Dim Calibration_done As Bit
Dim Write_flag As Bit
Dim Read_flag As Bit
Dim Calibrate_flag As Bit
Dim Start_flag As Bit
Dim Onetime As Bit

Dim Frequency As Dword
Dim Reference As Dword
Dim F_1 As Dword
Dim F_2 As Dword
Dim F_3 As Dword
Dim F_4 As Dword
Dim F_5 As Dword
Dim F_6 As Dword
Dim F_7 As Dword
Dim F_8 As Dword
Dim F_9 As Dword
Dim F_10 As Dword
Dim F_11 As Dword
Dim F_oscillator As Dword

Dim Delta As Dword
Dim Offset As Dword
Dim Offset_1 As Dword
Dim Offset_2 As Dword
Dim Offset_3 As Dword
Dim Offset_4 As Dword
Dim Offset_5 As Dword
Dim Offset_6 As Dword
Dim Offset_7 As Dword
Dim Offset_8 As Dword
Dim Offset_9 As Dword
Dim Offset_10 As Dword



Dim Temp1 As Dword
Dim Temp2 As Dword
Dim Temp3 As Dword
Dim Temp4 As Dword
Dim C_1 As Dword
Dim Cx As Dword
Dim L_1 As Dword
Dim L_2 As Word
Dim L_3 As Word
Dim L_4 As Word
Dim L_5 As Word
Dim L_6 As Word
Dim L_7 As Word

Dim Capacitance As Dword
Dim Fraction As Word
Dim Integers As Word
Dim Inductance As Dword
Dim Test_count As Dword
Dim Voltage As Word
Dim Volts As Word
Dim Mv As Word
Dim Offset_inductance As Dword
Dim Offset_count As Dword
Dim Number_above As Dword
Dim Switch As Word
Dim Previous_switch As Word
Dim C_time As Word
Dim L_time As Word

Dim Switch_value As Byte
Dim Correct_high As Byte
Dim Correct_low As Byte
Dim Adjustment As Integer

Dim Timeout_count As Byte
Dim F1_count As Byte

Config Timer1 = Timer , Prescale = 256

Cr Alias &H0D
Cap100 Alias Portd.7
Cap220 Alias Portb.1
Cap470_1 Alias Portb.0
Cap470_2 Alias Portb.2
Beep Alias Portd.5

Print "LC Meter MK3.4" ; Chr(cr);


$lib "glcdSSD1306-I2C.lib"
Config Graphlcd = Custom , Cols = 128 , Rows = 64 , Lcdname = "SSD1306"
Config Timer1 = Timer , Prescale = 1024
Setfont Font16x16
Config Adc = Single , Prescaler = Auto , Reference = Avcc       ' Use 5V ref

Config Int0 = Falling
Config Int1 = Falling
Config Scl = Portc.5                                   ' used i2c pins
Config Sda = Portc.4
I2cinit


Enable Int1
Enable Timer1
Enable Interrupts


On Int0 Count_pulses
On Int1 Set_calibrate
On Timer1 Tick


   Cap100 = 0                                          ' turn off all capacitors
   Cap220 = 0
   Cap470_1 = 0
   Cap470_2 = 0

Splash_screen:
    Lcdat 1 , 1 , "LC Meter" , 2
    Lcdat 3 , 1 , "  MKIII " , 2
    Lcdat 5 , 1 , "Ver 3.4 " , 2
    Lcdat 7 , 1 , "May 2022" , 2

   Wait 1
                                            ' allow to stabilise


  If Pind.6 = 1 Then Gosub Calibrate
  If Pind.6 = 0 Then L_1 = 2596                   ' default value before ca;ibration
  Cls                                             ' calibrate 11 values
  Waitms 100
  Onetime = 1

' *********************************** CAPACITOR CALCULATION ***************************************
'
'
'
' Loop here for various functions

Main:
   If Pind.6 = 1 Then Gosub Measure_c Else Gosub Measure_l
   Gosub Read_switch
   Goto Main


' Switch is a 3 position toggle on ADC1. Returns switch=0 in bottom
' switch=2 middle and switch=1 in top.

Read_switch:
   Switch = Getadc(1)
   Switch = Switch / 500                          ' change from 1024 max to 10 max
   If Switch <> Previous_switch Then Print "Switch = " ; Switch ; Chr(cr);
   Previous_switch = Switch
   If Switch = 2 Then Gosub Normal_time
   If Switch = 1 Then Gosub High_time
      Return


 Normal_time:
    C_time = 3907
    L_time = 31250
    Return


 High_time:
    C_time = 3907 * 2
    L_time = 31250                                '* 2
    Return



' ****************************************** START TIMER *******************************************
'
Start_timer:
   If Pind.6 = 1 Then Timer1 = 65535 - 3907       ' quarter second
   If Pind.6 = 0 Then Timer1 = 65535 - 31250      ' 2 seconds

   Frequency = 0
   Window = 1
   Enable Int0
   Return

' ******************************** MEASURE C ******************************

Measure_c:
   Portc.3 = 0

   Onetime = 1
   If Calibrate_flag = 1 Then Gosub Calibrate
   Gosub Start_timer
Wait_cwindow:
   If Window = 0 Then Gosub Show_capacitance Else Goto Wait_cwindow
   Return



Measure_l:
   If Onetime = 1 Then Cls
   If Onetime = 1 Then Lcdat 3 , 1 , " Press  "
   If Onetime = 1 Then Lcdat 5 , 1 , "CAL/READ"
   Onetime = 0
    If Pind.6 = 1 Then Goto Ml_exit                    ' no longer inductance
    Lcdat 1 , 1 , "* L uH  "
    Waitms 500
    Portc.3 = 1                                   ' Turn on Q5 via PortC.3
    Zero_flag = 1

Wait_start:
   If Start_flag = 0 Then Goto Wait_start
   Start_flag = 0
 '  If Switch = 1 Then Goto Wait_lwindow
   Lcdat 1 , 1 , "  L uH   "
   Print "Measuring L" ; Chr(cr);
   Gosub Start_timer

Wait_zwindow:
   If Window = 0 Then Reference = 1 * Frequency Else Goto Wait_zwindow

    Portc.3 = 0                                        ' turn off Q5
   Zero_flag = 0
   Gosub Start_timer

Wait_lwindow:
   If Window = 0 Then Gosub Show_inductance Else Goto Wait_lwindow
Ml_exit:
   Start_flag = 1
      Return





' ************************************* SHOW VALUE ************************************************
'
' Show value calculates L or C

Show_capacitance:
   Print "Freq = " ; Frequency ;                       ' Chr(cr);
   Gosub C_calculate
   Gosub Check_battery                                 'read battery voltage
   Return

Show_inductance:
   F_oscillator = Frequency * 4
   F_oscillator = F_oscillator / 1000
   Print "Ref=" ; Reference ;                     '" Freq=" ; F_oscillator;       ' Chr(cr);

   Offset = Reference - Frequency
   Print " Fosc=" ; F_oscillator ; " kHz Offset=" ; Offset ; Chr(cr);
   Gosub L_calculate
   Gosub Check_battery                                 'read battery voltage
   Return


' ****************************************** CHECK BATTERY ****************************************
'
' Read battery voltage on ADC0 and put on bottom line.
' 0-1023 corresponds to 0-5000 mV
' Display as BT=3.1V
'

Check_battery:
   Voltage = Getadc(0)
   Voltage = Voltage * 10
   Voltage = Voltage / 205
   Volts = Voltage / 10
   Mv = Voltage Mod 10
   Lcdat 7 , 1 , "Bat=" ; Volts ; "." ; Mv ; "V"
   Print " Battery = " ; Volts ; "." ; Mv ; "V"        ' ; Chr(cr);
    Return





' **************************************** L CALCULATE ********************************************
'
' Show inductance on line 3
'
'

L_calculate:

   Gosub Correction
   If Offset > 120000 Then Goto Error_read
   If Offset < 320 Then Goto Inductance_1
   If Offset < 3000 Then Goto Inductance_10
   If Offset < 24000 Then Goto Inductance_100
   If Offset < 70000 Then Goto Inductance_500
   If Offset < 89000 Then Goto Inductance_1000
   If Offset => 89000 Then Goto Inductance_2500
    Return

' The correction is for inductor other than 259.6 uH
' The inductance L_1 is measured during calibration
' and the value corrected as a ratio.

Correction:
   If L_1 > 2596 Then Gosub Reduce_offset
   If L_1 < 2596 Then Gosub Increase_offset
   Return

Reduce_offset:
   Offset = Offset * 2596
   Offset = Offset / L_1
   Return

Increase_offset:
   Offset = Offset * L_1
   Offset = Offset / 2596
   Return





 Error_read:
   Lcdat 3 , 1 , "Reading "
   Lcdat 5 , 1 , " Error  "
   Return

' Linear interpolation up to 1.0 uH
' L = Offset * 100/280

Inductance_1:
   Inductance = Offset * 100
   Inductance = Inductance / 280                  ' in0.01 increments
   Gosub Display_10
   Return

' -------------------------------------------------------------------------

' Linear interpolation up to 10 uH
' L = 36*offset/1000 in 0.1 uH

Inductance_10:
   Inductance = Offset * 36
   Inductance = Inductance / 100                       ' in0.01 increments
   Gosub Display_10
   Return
' -------------------------------------------------------------------------


' L = 4(offset*offset)/10000000 + 35*offset

Inductance_100:
  Temp1 = Offset * Offset
   Temp1 = Temp1 / 10000000
   Temp1 = Temp1 * 4
   Print "T1=" ; Temp1;
   Temp2 = Offset * 34
   Temp2 = Temp2 / 1000
   Print " T2=" ; Temp2 ; Chr(cr);
   Inductance = Temp1 + Temp2
   Gosub Display_l
   Return

' -------------------------------------------------------------------------

' Second order polynomial  100 - 500 uH
' L = 8f*f/10000000 + 0.002*f

Inductance_500:
   Temp1 = Offset / 100
   Temp1 = Temp1 * Temp1
   Temp1 = Temp1 / 1000
   Temp1 = Temp1 * 8
   Temp2 = 20 * Offset
   Temp2 = Temp2 / 1000
   Inductance = Temp1 + Temp2
   Inductance = Inductance + 50                   ' fudge factor
   Gosub Display_l
   Return

' -------------------------------------------------------------------------

' L =  5*F*F/1000000 - 0.0519*f + 1769

Inductance_1000:
   Offset = Offset / 10
   Temp1 = Offset * Offset
   Temp1 = Temp1 / 10000
   Temp1 = Temp1 * 5
   Temp2 = Offset * 519
   Temp2 = Temp2 / 100
   Print "T1=" ; Temp1 ; " T2=" ; Temp2 ; Chr(cr);

   Inductance = Temp1 + 17290
   Inductance = Inductance - Temp2

   Gosub Display_l
   Return

' -------------------------------------------------------------------------



' L = 0.0653F - 4815 with corrections

  Inductance_2500:
  Temp1 = Offset * 653
  Temp1 = Temp1 / 1000
    Print "T1=" ; Temp1 ; Chr(cr);

  If Offset < 90000 Then Goto Below_1250
  If Offset < 93600 Then Goto Below_1500
  If Offset < 99000 Then Goto Below_2000
  Inductance = Temp1 - 47320
  Gosub Display_l
   Return

Below_1250:
   Inductance = Temp1 - 47720
   Gosub Display_l
   Return

Below_1500:
   Inductance = Temp1 - 48540
   Gosub Display_l
   Return

Below_2000:
   Inductance = Temp1 - 49430
   Gosub Display_l
   Return

 ' -------------------------------------------------------------------------

Display_10:
   Integers = Inductance / 100
   Fraction = Inductance Mod 100
   If Fraction < 10 Then Print " L=" ; Integers ; ".0" ; Fraction ; "uH " ; Chr(cr);
   If Fraction => 10 Then Print " L=" ; Integers ; "." ; Fraction ; "uH " ; Chr(cr);
   If Fraction < 10 Then Lcdat 3 , 1 , "L=" ; Integers ; ".0" ; Fraction ; " "
    If Fraction => 10 Then Lcdat 3 , 1 , "L=" ; Integers ; "." ; Fraction ; " "
    Lcdat 5 , 1 , "F=" ; F_oscillator ; "kHz"
   Return

' -------------------------------------------------------------------------

Display_l:
   Integers = Inductance / 10
   Fraction = Inductance Mod 10
   Print " L=" ; Integers ; "." ; Fraction ; "uH " ; Chr(cr);
   If Integers < 10 Then Goto Below_10
   If Integers < 100 Then Goto Below_100
   If Integers < 1000 Then Goto Below_1000
   If Integers > 1000 Then Lcdat 3 , 1 , "L=" ; Integers ; " "
    Lcdat 5 , 1 , "F=" ; F_oscillator ; "kHz"
Dl_exit:
   Return

' -------------------------------------------------------------------------

Below_10:
   Lcdat 1 , 1 , "* L uH "
   Lcdat 3 , 1 , "L= " ; Integers ; "." ; Fraction ; " "
   Lcdat 5 , 1 , "F=" ; F_oscillator ; "kHz"
   Return

' -------------------------------------------------------------------------

Below_100:
  Lcdat 1 , 1 , "* L uH "
  Lcdat 3 , 1 , "L=" ; Integers ; "." ; Fraction ; " "
  Lcdat 5 , 1 , "F=" ; F_oscillator ; "kHz"
  Return

' -------------------------------------------------------------------------

Below_1000:
   Lcdat 1 , 1 , "* L uH "
   Lcdat 3 , 1 , "L= " ; Integers ; " "
   Lcdat 5 , 1 , "F=" ; F_oscillator ; "kHz"
   Return


' **************************************** C CALCULATE ********************************************
'
' Show capacitance on line 2 down to 0.1 pF resolution
' Inductance  = 1000 uH
' Piecewise continuous function in straight line seqments
' F1 is frequency with nothing added



C_calculate:
   Lcdat 1 , 1 , "  CAP   "
   If Frequency > F_1 Then Frequency = F_1
   Offset_count = F_1 - Frequency
   Print " Offset Count = " ; Offset_count ; Chr(cr);  ' DEBUG

   If Offset_count > Offset_10 Then Goto Above_1260pf
   If Offset_count > Offset_9 Then Goto Above_1160pf
   If Offset_count > Offset_8 Then Goto Above_1040pf
   If Offset_count > Offset_7 Then Goto Above_940pf
   If Offset_count > Offset_6 Then Goto Above_790pf
   If Offset_count > Offset_5 Then Goto Above_690pf
   If Offset_count > Offset_4 Then Goto Above_470pf
   If Offset_count > Offset_3 Then Goto Above_320pf
   If Offset_count > Offset_2 Then Goto Above_220pf
   If Offset_count > Offset_1 Then Goto Above_100pf
   Goto Above _0pf
   Return



 '
Display_cap:
   Lcdat 3 , 1 , "*       "
   If Capacitance < 5 Then Capacitance = 0             ' strays
   Integers = Capacitance / 10
   Fraction = Capacitance Mod 10
   Print " C = " ; Integers ; "." ; Fraction ; " pF " ;       '; Chr(cr);
   If Integers > 200 Then Gosub Round_off              '
   If Integers > 1000 Then Lcdat 5 , 1 , Integers ; " pF"
   If Integers =< 200 Then Lcdat 5 , 1 , Integers ; "." ; Fraction ; " pF"
   If Integers < 100 Then Lcdat 5 , 1 , Integers ; "." ; Fraction ; " pF "
   Waitms 250
   Lcdat 3 , 1 , "       "
   Return

Round_off:
   If Fraction => 5 Then Incr Integers                 ' round off number
   Lcdat 5 , 1 , Integers ; " pF  "
   Return



Above_0pf:
   Offset_count = Offset_count * 1000
   Capacitance = Offset_count / Offset_1
   Offset_count = Offset_count / 1000
   Print "NA1=" ; Offset_count ; " Delta=" ; Delta ;
   Gosub Display_cap
   Return

Above_100pf:
   Number_above = Offset_count - Offset_1
   Delta = Offset_2 - Offset_1
   Print "NA1=" ; Number_above ; " Delta=" ; Delta ;
   Capacitance = Number_above * 1200
   Capacitance = Capacitance / Delta
   Capacitance = Capacitance + 1000
   Gosub Display_cap
   Return

Above_220pf:
   Number_above = Offset_count - Offset_2
   Delta = Offset_3 - Offset_2
   Print "NA2=" ; Number_above ; " Delta=" ; Delta ;
   Capacitance = Number_above * 1000
   Capacitance = Capacitance / Delta
   Capacitance = Capacitance + 2200
   Gosub Display_cap
   Return

Above_320pf:
   Number_above = Offset_count - Offset_3
   Delta = Offset_4 - Offset_3
   Print "NA3=" ; Number_above ; " Delta=" ; Delta ;
   Capacitance = Number_above * 1500
   Capacitance = Capacitance / Delta
   Capacitance = Capacitance + 3200
   Gosub Display_cap
   Return

Above_470pf:
   Number_above = Offset_count - Offset_4
   Delta = Offset_5 - Offset_4
   Print "NA4=" ; Number_above ; " Delta=" ; Delta ;
   Capacitance = Number_above * 2200
   Capacitance = Capacitance / Delta
   Capacitance = Capacitance + 4700
   Gosub Display_cap
   Return


Above_690pf:
   Number_above = Offset_count - Offset_5
   Delta = Offset_6 - Offset_5
   Print "NA5=" ; Number_above ; " Delta=" ; Delta ;
   Capacitance = Number_above * 1000
   Capacitance = Capacitance / Delta
   Capacitance = Capacitance + 6900
   Gosub Display_cap
   Return

Above_790pf:
   Number_above = Offset_count - Offset_6
   Delta = Offset_7 - Offset_6
   Print "NA6=" ; Number_above ; " Delta=" ; Delta ;
   Capacitance = Number_above * 1500
   Capacitance = Capacitance / Delta
   Capacitance = Capacitance + 7900
   Gosub Display_cap
   Return

Above_940pf:
   Number_above = Offset_count - Offset_7
   Delta = Offset_8 - Offset_7
   Print "NA7=" ; Number_above ; " Delta=" ; Delta ;
   Capacitance = Number_above * 1000
   Capacitance = Capacitance / Delta
   Capacitance = Capacitance + 9400
   Gosub Display_cap
   Return

Above_1040pf:
   Number_above = Offset_count - Offset_8
   Delta = Offset_9 - Offset_8
   Print "NA8=" ; Number_above ; " Delta=" ; Delta ;
   Capacitance = Number_above * 1200
   Capacitance = Capacitance / Delta
   Capacitance = Capacitance + 10400
   Gosub Display_cap
   Return

Above_1160pf:
   Number_above = Offset_count - Offset_9
   Delta = Offset_10 - Offset_9
   Print "NA9=" ; Number_above ; " Delta=" ; Delta ;
   Capacitance = Number_above * 1000
   Capacitance = Capacitance / Delta
   Capacitance = Capacitance + 11600
   Gosub Display_cap
   Return

Above_1260pf:
   Number_above = Offset_count - Offset_10
   Delta = Offset_10 - Offset_9
   Print "NA10=" ; Number_above ; " Delta=" ; Delta ;
   Capacitance = Number_above * 1000
   Capacitance = Capacitance / Delta
   Capacitance = Capacitance + 12600
   Gosub Display_cap
   Return





' ********************************************* TIMER 0 INTERRUPT **********************************
'
' Tick sets the window size for counting. At 244/sec, 122 gives a half
' second window.

Tick:
   Window = 0
   Disable Int0
     Return

' ***************************************** INT0 INTERRUPT *****************************************
'
' If Window flag = 1 then count pulses

Count_pulses:
   If Window = 1 Then Incr Frequency
   Return

' ***************************************** INT1 INTERRUPT *****************************************
'
' Set calibrate flag to do calibration run

Set_calibrate:
   If Pind.6 = 1 Then Calibrate_flag = 1
   If Pind.6 = 0 Then Start_flag = 1
   Return


' *********************************************** CALIBRATE ****************************************
'
' Read frequencies for all CAPS off then CAPS combination

Calibrate:
   Calibrate_flag = 0
   Cap100 = 0                                          ' turn off all capacitors
   Cap220 = 0
   Cap470_1 = 0
   Cap470_2 = 0
    Print "Calibrating" ; Chr(cr);
    Lcdat 1 , 1 , " Calib  " , 2
    Lcdat 3 , 1 , " Wait   " , 2
    Lcdat 5 , 1 , "        "
    Lcdat 7 , 1 , "        "
    F_1 = 0
    F_2 = 0

    Waitms 100                                         ' allow to stabilise

   Gosub Start_timer

' F1 is the frequency with no calibration capacitors connected.

Wait_f1:
   If Window = 1 Then Goto Wait_f1                     ' wait for window to close
   F_1 = Frequency                                     ' store f1

   F_oscillator = F_1 * 32                              ' actual frequency

   Print "F1     0pF  " ; Frequency ; Chr(cr) ;
   Lcdat 5 , 1 , "C=  0 pF"
   Lcdat 7 , 1 , "O=" ; 0

'----------------------------------------------------------------------------

' 100 pF frequency
Next_freq:
   Cap100 = 1                                          ' turn on 100 pF
'   Waitms 50                                      ' allow to stabilise
   Gosub Start_timer

Wait_f2:

   If Window = 1 Then Goto Wait_f2                     ' wait for window to close
   F_2 = Frequency                                     ' store f2
   Offset_1 = F_1 - F_2

   Print "F2   100pF  " ; Frequency ; " O1 " ; Offset_1 ; Chr(cr);
   Cap100 = 0                                     ' turn off 100 pF
   Cap220 = 1                                          ' turn on 220 pF
   Lcdat 5 , 1 , "C= 100pF"
   Lcdat 7 , 1 , "O=" ; Offset_1                  ' allow to stabilise

   Gosub Start_timer

'----------------------------------------------------------------------------

' 220 pF frequency

Wait_f3:
   If Window = 1 Then Goto Wait_f3                     ' wait for window to close
   F_3 = Frequency                                     ' store f3
   Offset_2 = F_1 - F_3

   Print "F3   220pF  " ; Frequency ; " O2 " ; Offset_2 ; Chr(cr);


   Cap220 = 1                                          ' turn on 220 pF
   Cap100 = 1                                          ' turn on 100 pF
   Lcdat 5 , 1 , "C= 220pF"
   Lcdat 7 , 1 , "O=" ; Offset_2                       ' allow to stabilise
   Gosub Start_timer

'----------------------------------------------------------------------------
' 320 pF frequency

Wait_f4:

   If Window = 1 Then Goto Wait_f4                     ' wait for window to close
   F_4 = Frequency                                     ' store f4
   Offset_3 = F_1 - F_4

   Print "F4   320pF  " ; Frequency ; " O3 " ; Offset_3 ; Chr(cr);

   Cap100 = 0                                     ' turn off 100 pF
   Cap220 = 0                                          ' turn off 220 pF
   Cap470_1 = 1                                        ' turn on 470 pF
   Cap470_2 = 0
   Lcdat 5 , 1 , "C= 320pF"
   Lcdat 7 , 1 , "O=" ; Offset_3                       ' allow to stabilise
   Gosub Start_timer

'----------------------------------------------------------------------------

' 470 pF frequency

Wait_f5:
   If Window = 1 Then Goto Wait_f5                     ' wait for window to close
   F_5 = Frequency                                     ' store f5
   Offset_4 = F_1 - F_5

   Print "F5   470pF  " ; Frequency ; " O4 " ; Offset_4 ; Chr(cr);
   Cap470_2 = 0                                        ' turn off 470 pF
   Cap100 = 0                                          ' turn off 100 pF
   Cap470_1 = 1                                        ' turn on 470 pF
   Cap220 = 1                                          ' turn on 220 pF
   Lcdat 5 , 1 , "C= 470pF"
    Lcdat 7 , 1 , "O=" ; Offset_4                      ' allow to stabilise
  Gosub Start_timer
 '
'----------------------------------------------------------------------------

' 690 pF frequency

Wait_f6:
  If Window = 1 Then Goto Wait_f6                      ' wait for window to close
   F_6 = Frequency                                     ' store f6
   Offset_5 = F_1 - F_6

   Print "F6   690pF  " ; Frequency ; "  O5 " ; Offset_5 ; Chr(cr);

   Cap470_1 = 1                                        ' turn on 470 pF
   Cap220 = 1                                          ' turn on 220 pF
   Cap100 = 1                                          ' turn on 100 pF
   Cap470_2 = 0                                        ' turn off 470 pF
   Lcdat 5 , 1 , "C= 690pF"
   Lcdat 7 , 1 , "O=" ; Offset_5                       ' allow to stabilise
   Gosub Start_timer

'----------------------------------------------------------------------------

' 790 pF frequency

Wait_f7:
   If Window = 1 Then Goto Wait_f7                     ' wait for window to close
   F_7 = Frequency                                     ' store f7
   Offset_6 = F_1 - F_7

   Print "F7   790pF  " ; Frequency ; "  O6 " ; Offset_6 ; Chr(cr);

   Cap470_1 = 1                                        ' turn on 470 pF
   Cap470_2 = 1                                        ' turn on 470 pF
   Cap100 = 0                                          ' turn off 100 pF
   Cap220 = 0                                          ' turn off 220 pF
   Lcdat 5 , 1 , "C= 790pF"
   Lcdat 7 , 1 , "O=" ; Offset_6                       ' allow to stabilise
   Gosub Start_timer


'----------------------------------------------------------------------------

' 940 pF frequency

Wait_f8:
   If Window = 1 Then Goto Wait_f8                     ' wait for window to close
   F_8 = Frequency                                     ' store f8
   Offset_7 = F_1 - F_8

   Print "F8   940pF  " ; Frequency ; "  O7 " ; Offset_7 ; Chr(cr);

   Cap470_1 = 1                                        ' turn on 470 pF
   Cap470_2 = 1                                        ' turn on 470 pF
   Cap100 = 1                                          ' turn on 100 pF
   Cap220 = 0                                          ' turn off 220 pF
   Lcdat 5 , 1 , "C= 940pF"
    Lcdat 7 , 1 , "O=" ; Offset_7                      ' allow to stabilise
   Gosub Start_timer

'----------------------------------------------------------------------------


' 1040 pF frequency

Wait_f9:
   If Window = 1 Then Goto Wait_f9                     ' wait for window to close
   F_9 = Frequency                                     ' store f9
   Offset_8 = F_1 - F_9

   Print "F9  1040pF  " ; Frequency ; "  O8 " ; Offset_8 ; Chr(cr);

   Cap470_1 = 1                                        ' turn on 470 pF
   Cap470_2 = 1                                        ' turn on 470 pF
   Cap100 = 0                                          ' turn off 100 pF
   Cap220 = 1                                          ' turn on 220 pF
   Lcdat 5 , 1 , "C=1040pF"
    Lcdat 7 , 1 , "O=" ; Offset_8                      ' allow to stabilise
   Gosub Start_timer

'----------------------------------------------------------------------------

'1160 pF frequency

Wait_f10:
   If Window = 1 Then Goto Wait_f10                    ' wait for window to close
   F_10 = Frequency                                    ' store f10
   Offset_9 = F_1 - F_10

   Print "F10 1160pF  " ; Frequency ; "  O9 " ; Offset_9 ; Chr(cr);

   Cap470_1 = 1                                        ' turn on 470 pF
   Cap470_2 = 1                                        ' turn on 470 pF
   Cap100 = 1                                          ' turn on 100 pF
   Cap220 = 1                                          ' turn on 220 pF
   Lcdat 5 , 1 , "C=1160pF"
   Lcdat 7 , 1 , "O=" ; Offset_9                       ' allow to stabilise
   Gosub Start_timer

'----------------------------------------------------------------------------

'1260 pF frequency

Wait_f11:
   If Window = 1 Then Goto Wait_f11                    ' wait for window to close
   F_11 = Frequency                                    ' store f11
   Offset_10 = F_1 - F_11

   Print "F11 1260pF  " ; Frequency ; " O10 " ; Offset_10 ; Chr(cr);


   Cap100 = 0                                          ' turn off all capacitors
   Cap220 = 0
   Cap470_1 = 0
   Cap470_2 = 0
   Lcdat 5 , 1 , "C=1260pF"
   Lcdat 7 , 1 , "O=" ; Frequency                 ' turn off 220 pF
                                      ' allow to stabilise
   Frequency = 0
   Lcdat 3 , 1 , " Done   " , 2
   Lcdat 5 , 1 , "        "
   Lcdat 7 , 1 , "        "
   Print "Finished Calibration"
   Beep = 1
   Waitms 150
   Beep = 0
   Gosub Calculate_lc                             ' get values
    Waitms 500
   Return

' ********************************* CALCULATE LC *****************************
'
' Calculate LC gets values for oscillator inductance and capacitance
'
' C1 = f1*f1*Cx/(f1*f1 - f2*f2)
' Divide oscillator frequency by 16 and half second window, so 300 kHz max
' becomes 37,500 maximum count
' Cx is 100 pF


Calculate_lc:
   Print "F_1=" ; F_1 ; " F_2=" ; F_2 ; Chr(cr);

   Temp1 = F_1 * F_1
   Temp1 = Temp1 / 10
   Temp2 = F_2 * F_2
   Temp2 = Temp2 / 10
   Temp3 = Temp1 - Temp2
   Print "T1=" ; Temp1 ; " T2=" ; Temp2 ; " T3=" ; Temp3 ; Chr(cr);
   C_1 = Temp1 * 100
   C_1 = C_1 / Temp3
   C_1 = C_1 - 100                                     ' original tuning capacitor
   Print " C1 = " ; C_1 ;
   Temp1 = 2533000000 / C_1
   Temp1 = Temp1 * 100
   Temp1 = Temp1 / F_oscillator
   Temp2 = Temp1 * 1000000
    If Switch = 1 Then Temp2 = Temp2 * 4
   L_1 = Temp2 / F_oscillator

   Integers = L_1 / 10
   Fraction = L_1 Mod 10
   ' now the final value of L1
   Print " Inductance = " ; Integers ; "." ; Fraction ; "uH" ;
   Print " Fosc = " ; F_oscillator                '; Chr(cr);
   Return



   $include "font16x16.font"